#ifndef ZMODELER_STRUCT_LIST_H_INCLUDED
#define ZMODELER_STRUCT_LIST_H_INCLUDED

//----------------------------------
//   List template
//----------------------------------

template <class T>
class CZMList
{
private:
  //node type
  typedef struct tListNode
  {
    T             m_info;
    long          m_nIndex;
    tListNode*    m_next;
    tListNode*    m_prev;
  }tListNode;
  tListNode*      m_pHead;
  tListNode*      m_pTail;
  long            m_nAmount;

public:
  //
  // constructor/destructor
  //
  CZMList()  
  {
    m_pTail = NULL;
    m_pHead = NULL;
    m_nAmount=0;
  }
  ~CZMList()
  {
    Release();
  }

  //
  // operations:
  //

  //-------------------------------------------------------
  // @name : Find
  // Comment  
  // @param T& v                           : 
  //
  // @return long : index. -1 if not found;
  //-------------------------------------------------------
  long Find(T& v)
  {
    long res = -1;
    tListNode*  Ptr = m_pHead;
    while (Ptr && (res == -1) &&
           Ptr->m_next)
    {
      if (!memcmp(&Ptr->m_info, &v, sizeof(T)))
        res = Ptr->m_nIndex;
      else
        Ptr = Ptr->m_next;
    }
    return res;
  }

  //-------------------------------------------------------
  // @name : AddLast
  // Adds node to the tail, the list is ordered 0, 1, 2,...N-1, N
  // @param T& v                           : info to add
  //
  // @return long : index of added element in the list
  //-------------------------------------------------------
  long AddLast( T& v)
  {
    tListNode*  Ptr = new tListNode;
    if (!m_pHead)//first node
      m_pHead = m_pTail = Ptr;
    else
    {//add to the tail of the list
      m_pTail->m_next = Ptr;
      Ptr->m_prev = m_pTail;
      m_pTail = Ptr;
    }
    Ptr->m_next = NULL;
    memcpy(&Ptr->m_info, &v, sizeof(T));
    Ptr->m_nIndex = m_nAmount;
    m_nAmount++;
    return Ptr->m_nIndex;
  }
  

  //-------------------------------------------------------
  // @name : AddFirst
  // Adds node to the head. the list is ordered N, N-1,...,2,1,0
  // @param T& v                           : info to add
  //
  // @return long : index of added element in the list
  //-------------------------------------------------------
  long AddFirst(T& v)
  {
    tListNode*  Ptr = new tListNode;
    if (!m_pHead)//first node
      m_pHead = m_pTail = Ptr;
    else
    {//add to the head of the list
      m_pHead->m_prev = Ptr;
      Ptr->m_next = m_pHead;
      m_pHead = Ptr;
    }
    Ptr->m_prev = NULL;
    memcpy(&Ptr->m_info, &v, sizeof(T));
    Ptr->m_nIndex = m_nAmount;
    m_nAmount++;
    return Ptr->m_nIndex;
  }


  //-------------------------------------------------------
  // @name : AddUniqueFirst
  // Searches for supplied element and, if not found, adds first
  // @param T& v                           : info to search
  //
  // @return long : index in the list
  //-------------------------------------------------------
  long AddUniqueFirst(T& v)
  {
    long res = Find(v);
    if (-1 != res)
      return res;
    return AddFirst(v);
  }

  //-------------------------------------------------------
  // @name : AddUniqueLast
  // Searches for supplied element and, if not found, adds last
  // @param T& v                           : info to search
  //
  // @return long : index in the list
  //-------------------------------------------------------
  long AddUniqueLast(T& v)
  {
    long res = Find(v);
    if (-1 != res)
      return res;
    return AddLast(v);
  }

  //-------------------------------------------------------
  // @name : Size
  // @return long : Amount of elements in the list
  //-------------------------------------------------------
  long Size()
  {
    return m_nAmount;
  }


  //-------------------------------------------------------
  // @name : Release
  // Releases the list
  //-------------------------------------------------------
  void Release()
  {
    tListNode*  Ptr = m_pHead;
    while (Ptr)
    {
      m_pHead = Ptr;
      Ptr = Ptr->m_next;
      delete m_pHead;
    }
    m_nAmount = 0;
    m_pHead = NULL;
    m_pTail = NULL;
  }


  //-------------------------------------------------------
  // @name : GetLinearBuffer
  // provides a linear buffer, with a copy of controlled data
  //
  // @return T* : pointer to the buffer. YOU are responsible
  //              deallocation
  //-------------------------------------------------------
  T* GetLinearBuffer()
  {
    T* pBuf = new T[m_nAmount];
    int i = 0;
    for (tListNode*  Ptr = m_pHead; Ptr != NULL; Ptr = Ptr->m_next)
      memcpy(&pBuf[i++], &Ptr->m_info, sizeof(T));
    return pBuf;
  }

private:
};

#endif// ZMODELER_STRUCT_LIST_H_INCLUDED


